package com.sinosoftgz.starter.mybatisplus.entity;

import com.baomidou.mybatisplus.annotation.TableLogic;

import java.time.LocalDateTime;

/**
 * @author: Roney
 * @date: 2022-03-30 17:09
 * @description: 基础基类，ID类型为Long，使用逻辑删除
 */
public abstract class LongIdBaseEntity extends AbstractLongIdBaseEntity {

    /**
     * 逻辑删除标记
     */
    @TableLogic
    private Boolean deleteFlag;

    public Boolean getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        if (deleteFlag != null && deleteFlag) {
            deleteTime = LocalDateTime.now();
        }
        this.deleteFlag = deleteFlag;
    }
}
