package com.sinosoftgz.starter.mybatisplus.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.sinosoftgz.starter.mybatisplus.entity.BaseEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * Created by Roney on 2019/10/11.
 * 自动填充组件声明
 *
 * @author Roney
 * @date 2019-10-11 21:21
 */
@Component
@Slf4j
public class FillMetaObjectHandler implements MetaObjectHandler {


    /**
     * 新增的时候自动填充
     *
     * @param metaObject
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        log.debug("insert fill ....");
        if (metaObject.hasSetter(BaseEntity.CREATE_TIME_PROPERTY_NAME)) {
            this.setFieldValByName(BaseEntity.CREATE_TIME_PROPERTY_NAME, LocalDateTime.now(), metaObject);
        }
        if (metaObject.hasSetter(BaseEntity.DELETE_FLAG_PROPERTY_NAME)) {
            this.setFieldValByName(BaseEntity.DELETE_FLAG_PROPERTY_NAME, false, metaObject);
        }
        if (metaObject.hasSetter(BaseEntity.UPDATE_TIME_PROPERTY_NAME)) {
            this.setFieldValByName(BaseEntity.UPDATE_TIME_PROPERTY_NAME, LocalDateTime.now(), metaObject);
        }
        if (metaObject.hasSetter(BaseEntity.VERSION_PROPERTY_NAME)) {
            this.setFieldValByName(BaseEntity.VERSION_PROPERTY_NAME, 0, metaObject);
        }
    }

    /**
     * 更新的税后自动填充
     *
     * @param metaObject
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        log.debug("update fill ....");
        if (metaObject.hasSetter(BaseEntity.UPDATE_TIME_PROPERTY_NAME)) {
            this.setFieldValByName(BaseEntity.UPDATE_TIME_PROPERTY_NAME, LocalDateTime.now(), metaObject);
        }

        /**
         *  逻辑删除的删除日期
         */

        Boolean deleteFlag = (Boolean) this.getFieldValByName(BaseEntity.DELETE_FLAG_PROPERTY_NAME, metaObject);
        if (Boolean.TRUE.equals(deleteFlag) && null != deleteFlag) {
            this.setFieldValByName(BaseEntity.DELETE_TIME_PROPERTY_NAME, LocalDateTime.now(), metaObject);
        }

    }
}
