/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mybatisplus.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.sinosoftgz.starter.mybatisplus.handler.FillMetaObjectHandler;
import com.sinosoftgz.starter.mybatisplus.properties.MybatisPlusCustomProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MybatisPlusCustomProperties.class})
public class MybatisPlusConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfiguration.class);
    private final MybatisPlusCustomProperties properties;

    public MybatisPlusConfiguration(MybatisPlusCustomProperties properties) {
        this.properties = properties;
    }

    @Bean
    public GlobalConfig globalConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new FillMetaObjectHandler());
        return globalConfig;
    }

    @Bean
    public FillMetaObjectHandler fillMetaObjectHandler() {
        return new FillMetaObjectHandler();
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        this.enableIllegalSQL(interceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        return interceptor;
    }

    private void enableIllegalSQL(MybatisPlusInterceptor interceptor) {
        if (this.properties.getEnableIllegalSQL().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor());
        }
    }
}

