/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.druid.druid.log;

import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatLoggerAdapter;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomizeStatLogger
extends DruidDataSourceStatLoggerAdapter
implements DruidDataSourceStatLogger {
    private static final Logger log = LoggerFactory.getLogger(CustomizeStatLogger.class);

    public void log(DruidDataSourceStatValue statValue) {
        if (statValue.getSqlList().size() > 0) {
            for (JdbcSqlStatValue sqlStat : statValue.getSqlList()) {
                LinkedHashMap<String, Object> sqlStatMap = new LinkedHashMap<String, Object>();
                String sql = sqlStat.getSql().replace("\t", "");
                sql = sql.replace("\n", "");
                sqlStatMap.put("sql", sql);
                if (sqlStat.getExecuteCount() > 0L) {
                    sqlStatMap.put("executeCount", sqlStat.getExecuteCount());
                    sqlStatMap.put("executeMillisMax", sqlStat.getExecuteMillisMax());
                    sqlStatMap.put("executeMillisTotal", sqlStat.getExecuteMillisTotal());
                    sqlStatMap.put("createtime", LocalDateTime.now());
                    sqlStatMap.put("systemName", "SMRZ");
                }
                log.error(((Object)sqlStatMap).toString());
            }
        }
    }
}

