package com.sinosoftgz.starter.p6spy.log;

import com.p6spy.engine.spy.appender.MessageFormattingStrategy;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

/**
 * @author: Roney
 * @date: 2021-11-23 15:20
 * @description: P6spySqlFormat
 */
public class P6spySqlFormat implements MessageFormattingStrategy {
    @Override
    public String formatMessage(int connectionId, String now, long elapsed, String category, String prepared, String sql, String url) {
        return StringUtils.hasLength(sql) ? " CurrentTime: " + LocalDateTime.now() + " Consume Time：" + elapsed + " ms now: " + now +
                "\n Execute SQL：" + sql.replaceAll("[\\s]+", " ") + "\n" : "";
    }
}
