/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.common;

import com.sinosoftgz.common.config.DevopsConfig;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.common.utils.file.FileUploadUtils;
import com.sinosoftgz.common.utils.file.FileUtils;
import com.sinosoftgz.framework.config.ServerConfig;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private ServerConfig serverConfig;

    @GetMapping(value={"common/download"})
    public void fileDownload(String fileName, Boolean delete, HttpServletResponse response, HttpServletRequest request) {
        try {
            if (!FileUtils.checkAllowDownload((String)fileName)) {
                throw new Exception(StringUtils.format((String)"\u6587\u4ef6\u540d\u79f0({})\u975e\u6cd5\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8f7d\u3002 ", (Object[])new Object[]{fileName}));
            }
            String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
            String filePath = DevopsConfig.getDownloadPath() + fileName;
            response.setContentType("application/octet-stream");
            FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)realFileName);
            FileUtils.writeBytes((String)filePath, (OutputStream)response.getOutputStream());
            if (delete.booleanValue()) {
                FileUtils.deleteFile((String)filePath);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @PostMapping(value={"/common/upload"})
    public AjaxResult uploadFile(MultipartFile file) throws Exception {
        try {
            String filePath = DevopsConfig.getUploadPath();
            String fileName = FileUploadUtils.upload((String)filePath, (MultipartFile)file);
            String url = this.serverConfig.getUrl() + fileName;
            AjaxResult ajax = AjaxResult.success();
            ajax.put((Object)"fileName", (Object)fileName);
            ajax.put((Object)"url", (Object)url);
            return ajax;
        }
        catch (Exception e) {
            return AjaxResult.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/common/download/resource"})
    public void resourceDownload(String resource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (!FileUtils.checkAllowDownload((String)resource)) {
                throw new Exception(StringUtils.format((String)"\u8d44\u6e90\u6587\u4ef6({})\u975e\u6cd5\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8f7d\u3002 ", (Object[])new Object[]{resource}));
            }
            String localPath = DevopsConfig.getProfile();
            String downloadPath = localPath + StringUtils.substringAfter((String)resource, (String)"/profile");
            String downloadName = StringUtils.substringAfterLast((String)downloadPath, (String)"/");
            response.setContentType("application/octet-stream");
            FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)downloadName);
            FileUtils.writeBytes((String)downloadPath, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

