/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.monitor;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.page.TableDataInfo;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.system.domain.SysLogininfor;
import com.sinosoftgz.system.service.ISysLogininforService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/logininfor"})
public class SysLogininforController
extends BaseController {
    @Autowired
    private ISysLogininforService logininforService;

    @PreAuthorize(value="@ss.hasPermi('monitor:logininfor:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysLogininfor logininfor) {
        this.startPage();
        List list = this.logininforService.selectLogininforList(logininfor);
        return this.getDataTable(list);
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('monitor:logininfor:export')")
    @GetMapping(value={"/export"})
    public AjaxResult export(SysLogininfor logininfor) {
        List list = this.logininforService.selectLogininforList(logininfor);
        return null;
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:logininfor:remove')")
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{infoIds}"})
    public AjaxResult remove(@PathVariable Long[] infoIds) {
        return this.toAjax(this.logininforService.deleteLogininforByIds(infoIds));
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:logininfor:remove')")
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clean"})
    public AjaxResult clean() {
        this.logininforService.cleanLogininfor();
        return AjaxResult.success();
    }
}

