/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.system;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.entity.SysDictData;
import com.sinosoftgz.common.core.page.TableDataInfo;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.common.utils.SecurityUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.system.service.ISysDictDataService;
import com.sinosoftgz.system.service.ISysDictTypeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dict/data"})
public class SysDictDataController
extends BaseController {
    @Autowired
    private ISysDictDataService dictDataService;
    @Autowired
    private ISysDictTypeService dictTypeService;

    @PreAuthorize(value="@ss.hasPermi('system:dict:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysDictData dictData) {
        this.startPage();
        List list = this.dictDataService.selectDictDataList(dictData);
        return this.getDataTable(list);
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('system:dict:export')")
    @GetMapping(value={"/export"})
    public AjaxResult export(SysDictData dictData) {
        List list = this.dictDataService.selectDictDataList(dictData);
        return null;
    }

    @PreAuthorize(value="@ss.hasPermi('system:dict:query')")
    @GetMapping(value={"/{dictCode}"})
    public AjaxResult getInfo(@PathVariable Long dictCode) {
        return AjaxResult.success((Object)this.dictDataService.selectDictDataById(dictCode));
    }

    @GetMapping(value={"/type/{dictType}"})
    public AjaxResult dictType(@PathVariable String dictType) {
        ArrayList data = this.dictTypeService.selectDictDataByType(dictType);
        if (StringUtils.isNull((Object)data)) {
            data = new ArrayList();
        }
        return AjaxResult.success((Object)data);
    }

    @PreAuthorize(value="@ss.hasPermi('system:dict:add')")
    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysDictData dict) {
        dict.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.dictDataService.insertDictData(dict));
    }

    @PreAuthorize(value="@ss.hasPermi('system:dict:edit')")
    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysDictData dict) {
        dict.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.dictDataService.updateDictData(dict));
    }

    @PreAuthorize(value="@ss.hasPermi('system:dict:remove')")
    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{dictCodes}"})
    public AjaxResult remove(@PathVariable Long[] dictCodes) {
        return this.toAjax(this.dictDataService.deleteDictDataByIds(dictCodes));
    }
}

