/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.system;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.entity.SysMenu;
import com.sinosoftgz.common.core.domain.model.LoginUser;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.common.utils.SecurityUtils;
import com.sinosoftgz.common.utils.ServletUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.framework.web.service.TokenService;
import com.sinosoftgz.system.service.ISysMenuService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/menu"})
public class SysMenuController
extends BaseController {
    @Autowired
    private ISysMenuService menuService;
    @Autowired
    private TokenService tokenService;

    @PreAuthorize(value="@ss.hasPermi('system:menu:list')")
    @GetMapping(value={"/list"})
    public AjaxResult list(SysMenu menu) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        List menus = this.menuService.selectMenuList(menu, userId);
        return AjaxResult.success((Object)menus);
    }

    @PreAuthorize(value="@ss.hasPermi('system:menu:query')")
    @GetMapping(value={"/{menuId}"})
    public AjaxResult getInfo(@PathVariable Long menuId) {
        return AjaxResult.success((Object)this.menuService.selectMenuById(menuId));
    }

    @GetMapping(value={"/treeselect"})
    public AjaxResult treeselect(SysMenu menu) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        List menus = this.menuService.selectMenuList(menu, userId);
        return AjaxResult.success((Object)this.menuService.buildMenuTreeSelect(menus));
    }

    @GetMapping(value={"/roleMenuTreeselect/{roleId}"})
    public AjaxResult roleMenuTreeselect(@PathVariable(value="roleId") Long roleId) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        List menus = this.menuService.selectMenuList(loginUser.getUser().getUserId());
        AjaxResult ajax = AjaxResult.success();
        ajax.put((Object)"checkedKeys", (Object)this.menuService.selectMenuListByRoleId(roleId));
        ajax.put((Object)"menus", (Object)this.menuService.buildMenuTreeSelect(menus));
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('system:menu:add')")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysMenu menu) {
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return AjaxResult.error((String)("\u65b0\u589e\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.startsWithAny((CharSequence)menu.getPath(), (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            return AjaxResult.error((String)("\u65b0\u589e\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934"));
        }
        menu.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.menuService.insertMenu(menu));
    }

    @PreAuthorize(value="@ss.hasPermi('system:menu:edit')")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysMenu menu) {
        if ("1".equals(this.menuService.checkMenuNameUnique(menu))) {
            return AjaxResult.error((String)("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.startsWithAny((CharSequence)menu.getPath(), (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            return AjaxResult.error((String)("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934"));
        }
        if (menu.getMenuId().equals(menu.getParentId())) {
            return AjaxResult.error((String)("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u4e0a\u7ea7\u83dc\u5355\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1"));
        }
        menu.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.menuService.updateMenu(menu));
    }

    @PreAuthorize(value="@ss.hasPermi('system:menu:remove')")
    @Log(title="\u83dc\u5355\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{menuId}"})
    public AjaxResult remove(@PathVariable(value="menuId") Long menuId) {
        if (this.menuService.hasChildByMenuId(menuId)) {
            return AjaxResult.error((String)"\u5b58\u5728\u5b50\u83dc\u5355,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.menuService.checkMenuExistRole(menuId)) {
            return AjaxResult.error((String)"\u83dc\u5355\u5df2\u5206\u914d,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.toAjax(this.menuService.deleteMenuById(menuId));
    }
}

