/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.system;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.config.DevopsConfig;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.entity.SysUser;
import com.sinosoftgz.common.core.domain.model.LoginUser;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.common.utils.SecurityUtils;
import com.sinosoftgz.common.utils.ServletUtils;
import com.sinosoftgz.common.utils.file.FileUploadUtils;
import com.sinosoftgz.framework.web.service.TokenService;
import com.sinosoftgz.system.service.ISysUserService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/user/profile"})
public class SysProfileController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private TokenService tokenService;

    @GetMapping
    public AjaxResult profile() {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        SysUser user = loginUser.getUser();
        AjaxResult ajax = AjaxResult.success((Object)user);
        ajax.put((Object)"roleGroup", (Object)this.userService.selectUserRoleGroup(loginUser.getUsername()));
        ajax.put((Object)"postGroup", (Object)this.userService.selectUserPostGroup(loginUser.getUsername()));
        return ajax;
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult updateProfile(@RequestBody SysUser user) {
        if (this.userService.updateUserProfile(user) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            loginUser.getUser().setNickName(user.getNickName());
            loginUser.getUser().setPhonenumber(user.getPhonenumber());
            loginUser.getUser().setEmail(user.getEmail());
            loginUser.getUser().setSex(user.getSex());
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updatePwd"})
    public AjaxResult updatePwd(String oldPassword, String newPassword) {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        String userName = loginUser.getUsername();
        String password = loginUser.getPassword();
        if (!SecurityUtils.matchesPassword((String)oldPassword, (String)password)) {
            return AjaxResult.error((String)"\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        if (SecurityUtils.matchesPassword((String)newPassword, (String)password)) {
            return AjaxResult.error((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        if (this.userService.resetUserPwd(userName, SecurityUtils.encryptPassword((String)newPassword)) > 0) {
            loginUser.getUser().setPassword(SecurityUtils.encryptPassword((String)newPassword));
            this.tokenService.setLoginUser(loginUser);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u4fee\u6539\u5bc6\u7801\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @Log(title="\u7528\u6237\u5934\u50cf", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/avatar"})
    public AjaxResult avatar(@RequestParam(value="avatarfile") MultipartFile file) throws IOException {
        if (!file.isEmpty()) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            String avatar = FileUploadUtils.upload((String)DevopsConfig.getAvatarPath(), (MultipartFile)file);
            if (this.userService.updateUserAvatar(loginUser.getUsername(), avatar)) {
                AjaxResult ajax = AjaxResult.success();
                ajax.put((Object)"imgUrl", (Object)avatar);
                loginUser.getUser().setAvatar(avatar);
                this.tokenService.setLoginUser(loginUser);
                return ajax;
            }
        }
        return AjaxResult.error((String)"\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

