/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.system;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.entity.SysRole;
import com.sinosoftgz.common.core.domain.model.LoginUser;
import com.sinosoftgz.common.core.page.TableDataInfo;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.common.utils.SecurityUtils;
import com.sinosoftgz.common.utils.ServletUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.framework.web.service.SysPermissionService;
import com.sinosoftgz.framework.web.service.TokenService;
import com.sinosoftgz.system.service.ISysRoleService;
import com.sinosoftgz.system.service.ISysUserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/role"})
public class SysRoleController
extends BaseController {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysPermissionService permissionService;
    @Autowired
    private ISysUserService userService;

    @PreAuthorize(value="@ss.hasPermi('system:role:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysRole role) {
        this.startPage();
        List list = this.roleService.selectRoleList(role);
        return this.getDataTable(list);
    }

    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('system:role:export')")
    @GetMapping(value={"/export"})
    public AjaxResult export(SysRole role) {
        List list = this.roleService.selectRoleList(role);
        return null;
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:query')")
    @GetMapping(value={"/{roleId}"})
    public AjaxResult getInfo(@PathVariable Long roleId) {
        return AjaxResult.success((Object)this.roleService.selectRoleById(roleId));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:add')")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysRole role) {
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728"));
        }
        role.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.insertRole(role));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:edit')")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return AjaxResult.error((String)("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728"));
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return AjaxResult.error((String)("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728"));
        }
        role.setUpdateBy(SecurityUtils.getUsername());
        if (this.roleService.updateRole(role) > 0) {
            LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
            if (StringUtils.isNotNull((Object)loginUser.getUser()) && !loginUser.getUser().isAdmin()) {
                loginUser.setPermissions(this.permissionService.getMenuPermission(loginUser.getUser()));
                loginUser.setUser(this.userService.selectUserByUserName(loginUser.getUser().getUserName()));
                this.tokenService.setLoginUser(loginUser);
            }
            return AjaxResult.success();
        }
        return AjaxResult.error((String)("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:edit')")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/dataScope"})
    public AjaxResult dataScope(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        return this.toAjax(this.roleService.authDataScope(role));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:edit')")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysRole role) {
        this.roleService.checkRoleAllowed(role);
        role.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.roleService.updateRoleStatus(role));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:remove')")
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{roleIds}"})
    public AjaxResult remove(@PathVariable Long[] roleIds) {
        return this.toAjax(this.roleService.deleteRoleByIds(roleIds));
    }

    @PreAuthorize(value="@ss.hasPermi('system:role:query')")
    @GetMapping(value={"/optionselect"})
    public AjaxResult optionselect() {
        return AjaxResult.success((Object)this.roleService.selectRoleAll());
    }
}

