/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.system;

import com.sinosoftgz.common.annotation.Log;
import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.entity.SysUser;
import com.sinosoftgz.common.core.domain.model.LoginUser;
import com.sinosoftgz.common.core.page.TableDataInfo;
import com.sinosoftgz.common.enums.BusinessType;
import com.sinosoftgz.common.utils.SecurityUtils;
import com.sinosoftgz.common.utils.ServletUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.framework.web.service.TokenService;
import com.sinosoftgz.system.service.ISysPostService;
import com.sinosoftgz.system.service.ISysRoleService;
import com.sinosoftgz.system.service.ISysUserService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/user"})
public class SysUserController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysPostService postService;
    @Autowired
    private TokenService tokenService;

    @PreAuthorize(value="@ss.hasPermi('system:user:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('system:user:export')")
    @GetMapping(value={"/export"})
    public AjaxResult export(SysUser user) {
        List list = this.userService.selectUserList(user);
        return null;
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PreAuthorize(value="@ss.hasPermi('system:user:import')")
    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
        String operName = loginUser.getUsername();
        return null;
    }

    @GetMapping(value={"/importTemplate"})
    public AjaxResult importTemplate() {
        return null;
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:query')")
    @GetMapping(value={"/", "/{userId}"})
    public AjaxResult getInfo(@PathVariable(value="userId", required=false) Long userId) {
        AjaxResult ajax = AjaxResult.success();
        List roles = this.roleService.selectRoleAll();
        ajax.put((Object)"roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        ajax.put((Object)"posts", (Object)this.postService.selectPostAll());
        if (StringUtils.isNotNull((Object)userId)) {
            ajax.put((Object)"data", (Object)this.userService.selectUserById(userId));
            ajax.put((Object)"postIds", (Object)this.postService.selectPostListByUserId(userId));
            ajax.put((Object)"roleIds", (Object)this.roleService.selectRoleListByUserId(userId));
        }
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:add')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysUser user) {
        if ("1".equals(this.userService.checkUserNameUnique(user.getUserName()))) {
            return AjaxResult.error((String)("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return AjaxResult.error((String)("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return AjaxResult.error((String)("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        user.setCreateBy(SecurityUtils.getUsername());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        return this.toAjax(this.userService.insertUser(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:edit')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return AjaxResult.error((String)("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return AjaxResult.error((String)("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUser(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:remove')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{userIds}"})
    public AjaxResult remove(@PathVariable Long[] userIds) {
        return this.toAjax(this.userService.deleteUserByIds(userIds));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:resetPwd')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwd"})
    public AjaxResult resetPwd(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @PreAuthorize(value="@ss.hasPermi('system:user:edit')")
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUserStatus(user));
    }
}

