/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.web.controller.tool;

import com.sinosoftgz.common.core.controller.BaseController;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.web.controller.tool.UserEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7528\u6237\u4fe1\u606f\u7ba1\u7406")
@RestController
@RequestMapping(value={"/test/user"})
public class TestController
extends BaseController {
    private static final Map<Integer, UserEntity> users = new LinkedHashMap<Integer, UserEntity>();

    public TestController() {
        users.put(1, new UserEntity(1, "admin", "admin123", "15888888888"));
        users.put(2, new UserEntity(2, "ry", "admin123", "15666666666"));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/list"})
    public AjaxResult userList() {
        ArrayList<UserEntity> userList = new ArrayList<UserEntity>(users.values());
        return AjaxResult.success(userList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8be6\u7ec6")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path")
    @GetMapping(value={"/{userId}"})
    public AjaxResult getUser(@PathVariable Integer userId) {
        if (!users.isEmpty() && users.containsKey(userId)) {
            return AjaxResult.success((Object)users.get(userId));
        }
        return AjaxResult.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @ApiImplicitParam(name="userEntity", value="\u65b0\u589e\u7528\u6237\u4fe1\u606f", dataType="UserEntity")
    @PostMapping(value={"/save"})
    public AjaxResult save(UserEntity user) {
        if (StringUtils.isNull((Object)user) || StringUtils.isNull((Object)user.getUserId())) {
            return AjaxResult.error((String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return AjaxResult.success((Object)users.put(user.getUserId(), user));
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237")
    @ApiImplicitParam(name="userEntity", value="\u65b0\u589e\u7528\u6237\u4fe1\u606f", dataType="UserEntity")
    @PutMapping(value={"/update"})
    public AjaxResult update(UserEntity user) {
        if (StringUtils.isNull((Object)user) || StringUtils.isNull((Object)user.getUserId())) {
            return AjaxResult.error((String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (users.isEmpty() || !users.containsKey(user.getUserId())) {
            return AjaxResult.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        users.remove(user.getUserId());
        return AjaxResult.success((Object)users.put(user.getUserId(), user));
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path")
    @DeleteMapping(value={"/{userId}"})
    public AjaxResult delete(@PathVariable Integer userId) {
        if (!users.isEmpty() && users.containsKey(userId)) {
            users.remove(userId);
            return AjaxResult.success();
        }
        return AjaxResult.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
    }
}

