/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.common.utils;

import com.sinosoftgz.common.core.domain.entity.SysDictData;
import com.sinosoftgz.common.core.redis.RedisCache;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.common.utils.spring.SpringUtils;
import java.util.Collection;
import java.util.List;

public class DictUtils {
    public static final String SEPARATOR = ",";

    public static void setDictCache(String key, List<SysDictData> dictDatas) {
        SpringUtils.getBean(RedisCache.class).setCacheObject(DictUtils.getCacheKey(key), dictDatas);
    }

    public static List<SysDictData> getDictCache(String key) {
        Object cacheObj = SpringUtils.getBean(RedisCache.class).getCacheObject(DictUtils.getCacheKey(key));
        if (StringUtils.isNotNull(cacheObj)) {
            List dictDatas = (List)StringUtils.cast(cacheObj);
            return dictDatas;
        }
        return null;
    }

    public static String getDictLabel(String dictType, String dictValue) {
        return DictUtils.getDictLabel(dictType, dictValue, SEPARATOR);
    }

    public static String getDictValue(String dictType, String dictLabel) {
        return DictUtils.getDictValue(dictType, dictLabel, SEPARATOR);
    }

    public static String getDictLabel(String dictType, String dictValue, String separator) {
        StringBuilder propertyString = new StringBuilder();
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.containsAny((CharSequence)separator, (CharSequence)dictValue) && StringUtils.isNotEmpty(datas)) {
            block0: for (SysDictData dict : datas) {
                for (String value : dictValue.split(separator)) {
                    if (!value.equals(dict.getDictValue())) continue;
                    propertyString.append(dict.getDictLabel() + separator);
                    continue block0;
                }
            }
        } else {
            for (SysDictData dict : datas) {
                if (!dictValue.equals(dict.getDictValue())) continue;
                return dict.getDictLabel();
            }
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String getDictValue(String dictType, String dictLabel, String separator) {
        StringBuilder propertyString = new StringBuilder();
        List<SysDictData> datas = DictUtils.getDictCache(dictType);
        if (StringUtils.containsAny((CharSequence)separator, (CharSequence)dictLabel) && StringUtils.isNotEmpty(datas)) {
            block0: for (SysDictData dict : datas) {
                for (String label : dictLabel.split(separator)) {
                    if (!label.equals(dict.getDictLabel())) continue;
                    propertyString.append(dict.getDictValue() + separator);
                    continue block0;
                }
            }
        } else {
            for (SysDictData dict : datas) {
                if (!dictLabel.equals(dict.getDictLabel())) continue;
                return dict.getDictValue();
            }
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static void clearDictCache() {
        Collection<String> keys = SpringUtils.getBean(RedisCache.class).keys("sys_dict:*");
        SpringUtils.getBean(RedisCache.class).deleteObject(keys);
    }

    public static String getCacheKey(String configKey) {
        return "sys_dict:" + configKey;
    }
}

