/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.devops.example.consumer.biz.impl;

import com.sinosoftgz.devops.example.consumer.biz.DemoBiz;
import com.sinosoftgz.devops.example.dto.DemoDTO;
import com.sinosoftgz.devops.example.mapping.DemoDtoMapping;
import com.sinosoftgz.devops.example.protocal.rpc.api.DemoApi;
import com.sinosoftgz.devops.example.vo.DemoVO;
import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.page.ResultPage;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="consumerDemoBiz")
public class DemoBizImpl
implements DemoBiz {
    private static final Logger log = LoggerFactory.getLogger(DemoBizImpl.class);
    @MotanReferer
    DemoApi demoApi;
    @Resource
    DemoDtoMapping demoMapping;

    public DemoVO prepareAddDemoVO(DemoVO demoVO) {
        return this.addDemoVO(demoVO);
    }

    public DemoVO addDemoVO(DemoVO demoVO) {
        Assert.notNull((Object)demoVO, (String)"Object must be have value!");
        DemoDTO demoDTO = this.targetToSource(demoVO);
        return this.sourceToTarget(this.demoApi.addDemoDTO(demoDTO));
    }

    public List<DemoVO> batchAddDemoVO(List<DemoVO> demoVOs) {
        Assert.notNull(demoVOs, (String)"Object must be have value!");
        List demoDTOs = this.targetToSource(demoVOs);
        return this.sourceToTarget(this.demoApi.batchAddDemoDTO(demoDTOs));
    }

    public DemoVO prepareUpdateDemoVO(DemoVO demoVO) {
        return this.prepareAddDemoVO(demoVO);
    }

    public DemoVO updateDemoVO(DemoVO demoVO) {
        return this.addDemoVO(demoVO);
    }

    public List<DemoVO> batchUpdateDemoVO(List<DemoVO> demoVOs) {
        return this.batchAddDemoVO(demoVOs);
    }

    public int deleteById(Long demoId) {
        return this.demoApi.deleteById(demoId);
    }

    public int deleteByIds(List<Long> demoIds) {
        return this.demoApi.deleteByIds(demoIds);
    }

    public int deleteDemoVO(DemoVO demoVO) {
        DemoDTO demoDTO = this.targetToSource(demoVO);
        return this.demoApi.batchDeleteDemoDTO(this.demoApi.findDemoDTO(demoDTO));
    }

    public int batchDeleteDemoVO(List<DemoVO> demoVOs) {
        List demoDTOs = this.targetToSource(demoVOs);
        return this.demoApi.batchDeleteDemoDTO(demoDTOs);
    }

    public DemoVO viewDemoVO(Long demoId) {
        return this.findById(demoId);
    }

    public List<DemoVO> prepareFindDemoVO(DemoVO demoVO) {
        return this.findDemoVO(demoVO);
    }

    public List<DemoVO> findDemoVO(DemoVO demoVO) {
        DemoDTO demoDTO = this.targetToSource(demoVO);
        return this.sourceToTarget(this.demoApi.findDemoDTO(demoDTO));
    }

    public DemoVO findById(Long demoId) {
        Assert.notNull((Object)demoId, (String)"id must have value");
        return this.sourceToTarget(this.demoApi.findById(demoId));
    }

    public List<DemoVO> findByIds(List<Long> demoIds) {
        Assert.notNull(demoIds, (String)"ids must have value");
        return this.sourceToTarget(this.demoApi.findByIds(demoIds));
    }

    public ResultPage<DemoVO> findDemoVOPage(PageQueryRequest pageQueryRequest) {
        return this.demoMapping.sourceToTarget(this.demoApi.findDemoDTOPage(pageQueryRequest));
    }

    private DemoDTO targetToSource(DemoVO demoVO) {
        return (DemoDTO)this.demoMapping.targetToSource((Object)demoVO);
    }

    private DemoVO sourceToTarget(DemoDTO demo) {
        return (DemoVO)this.demoMapping.sourceToTarget((Object)demo);
    }

    private List<DemoDTO> targetToSource(List<DemoVO> demoVOs) {
        return this.demoMapping.targetToSource(demoVOs);
    }

    private List<DemoVO> sourceToTarget(List<DemoDTO> demos) {
        return this.demoMapping.sourceToTarget(demos);
    }
}

