/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.devops.example.service.impl;

import com.sinosoftgz.devops.example.domain.Demo;
import com.sinosoftgz.devops.example.repository.DemoRepos;
import com.sinosoftgz.devops.example.service.IDemoService;
import com.sinosoftgz.devops.example.specification.DemoSpecification;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DemoServiceImpl
implements IDemoService {
    private static final Logger log = LoggerFactory.getLogger(DemoServiceImpl.class);
    @Autowired
    DemoRepos demoRepos;

    public Demo prepareAddDemo(Demo demo) {
        return this.addDemo(demo);
    }

    public Demo addDemo(Demo demo) {
        Assert.notNull((Object)demo, (String)"Object must be have value!");
        return (Demo)this.demoRepos.save((Object)demo);
    }

    public List<Demo> batchAddDemo(List<Demo> demos) {
        Assert.notNull(demos, (String)"Object must be have value!");
        return this.demoRepos.save(demos);
    }

    public Demo prepareUpdateDemo(Demo demo) {
        return this.prepareAddDemo(demo);
    }

    public Demo updateDemo(Demo demo) {
        return this.addDemo(demo);
    }

    public List<Demo> batchUpdateDemo(List<Demo> demos) {
        return this.batchAddDemo(demos);
    }

    public int deleteById(Long demoId) {
        Assert.notNull((Object)demoId, (String)"id must have value");
        try {
            this.demoRepos.delete((Serializable)demoId);
            return 1;
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    public int deleteByIds(List<Long> demoIds) {
        Assert.notNull(demoIds, (String)"ids must have value");
        List demos = this.findByIds(demoIds);
        return this.batchDeleteDemo(demos);
    }

    public int deleteDemo(Demo demo) {
        Assert.notNull((Object)demo, (String)"demo must have value");
        try {
            this.demoRepos.delete((Object)demo);
            return 1;
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    public int batchDeleteDemo(List<Demo> demos) {
        Assert.notNull(demos, (String)"demos must have value");
        try {
            this.demoRepos.deleteInBatch(demos);
            return demos.size();
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    public Demo viewDemo(Long demoId) {
        return this.findById(demoId);
    }

    public List<Demo> prepareFindDemo(Demo demo) {
        return this.findDemo(demo);
    }

    public List<Demo> findDemo(Demo demo) {
        DemoSpecification querySpecification = new DemoSpecification(demo);
        return this.demoRepos.findAll((Specification)querySpecification);
    }

    public Demo findById(Long demoId) {
        Assert.notNull((Object)demoId, (String)"id must have value");
        return (Demo)this.demoRepos.findOne((Serializable)demoId);
    }

    public List<Demo> findByIds(List<Long> demoIds) {
        Assert.notNull(demoIds, (String)"ids must have value");
        return this.demoRepos.findAll(demoIds);
    }

    public Page<Demo> findDemoPage(Demo demo, Pageable pageable) {
        DemoSpecification querySpecification = new DemoSpecification(demo);
        return this.demoRepos.findAll((Specification)querySpecification, pageable);
    }
}

