/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.devops.example.specification;

import com.sinosoftgz.common.utils.LangUtils;
import com.sinosoftgz.devops.example.domain.Demo;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

public class DemoSpecification<T>
implements Specification<T> {
    private static final Logger log = LoggerFactory.getLogger(DemoSpecification.class);
    private Demo demo;

    public DemoSpecification() {
    }

    public DemoSpecification(Demo demo) {
        this.demo = demo;
    }

    public Demo getDemo() {
        return this.demo;
    }

    public void setDemo(Demo demo) {
        this.demo = demo;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!LangUtils.isEmpty((Object)this.demo)) {
            String demoContent;
            Long demoId = this.demo.getDemoId();
            if (!LangUtils.isEmpty((Object)demoId)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("demoId"), (Object)demoId));
            }
            if (!LangUtils.isEmpty((Object)(demoContent = this.demo.getDemoContent()))) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("demoContent"), (Object)demoContent));
            }
        }
        return criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()])).getRestriction();
    }
}

