/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.framework.security.handle;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.core.domain.model.LoginUser;
import com.sinosoftgz.common.utils.ServletUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.framework.manager.AsyncManager;
import com.sinosoftgz.framework.manager.factory.AsyncFactory;
import com.sinosoftgz.framework.web.service.TokenService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
public class LogoutSuccessHandlerImpl
implements LogoutSuccessHandler {
    @Autowired
    private TokenService tokenService;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        if (StringUtils.isNotNull((Object)loginUser)) {
            String userName = loginUser.getUsername();
            this.tokenService.delLoginUser(loginUser.getToken());
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(userName, "Logout", "\u9000\u51fa\u6210\u529f", new Object[0]));
        }
        ServletUtils.renderString((HttpServletResponse)response, (String)JSON.toJSONString((Object)AjaxResult.error((int)200, (String)"\u9000\u51fa\u6210\u529f")));
    }
}

