/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.framework.web.exception;

import com.sinosoftgz.common.core.domain.AjaxResult;
import com.sinosoftgz.common.exception.BaseException;
import com.sinosoftgz.common.exception.CustomException;
import com.sinosoftgz.common.exception.DemoModeException;
import com.sinosoftgz.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public AjaxResult baseException(BaseException e) {
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={CustomException.class})
    public AjaxResult businessException(CustomException e) {
        if (StringUtils.isNull((Object)e.getCode())) {
            return AjaxResult.error((String)e.getMessage());
        }
        return AjaxResult.error((int)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public AjaxResult handlerNoFoundException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((int)404, (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public AjaxResult handleAuthorizationException(AccessDeniedException e) {
        log.error(e.getMessage());
        return AjaxResult.error((int)403, (String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={AccountExpiredException.class})
    public AjaxResult handleAccountExpiredException(AccountExpiredException e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={UsernameNotFoundException.class})
    public AjaxResult handleUsernameNotFoundException(UsernameNotFoundException e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult validatedBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object validExceptionHandler(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = e.getBindingResult().getFieldError().getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={DemoModeException.class})
    public AjaxResult demoModeException(DemoModeException e) {
        return AjaxResult.error((String)"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
    }
}

