/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.framework.web.service;

import com.sinosoftgz.common.core.domain.entity.SysUser;
import com.sinosoftgz.system.service.ISysMenuService;
import com.sinosoftgz.system.service.ISysRoleService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysPermissionService {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysMenuService menuService;

    public Set<String> getRolePermission(SysUser user) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(user.getUserId()));
        }
        return roles;
    }

    public Set<String> getMenuPermission(SysUser user) {
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            perms.addAll(this.menuService.selectMenuPermsByUserId(user.getUserId()));
        }
        return perms;
    }
}

