/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.generator.util;

import com.alibaba.fastjson.JSONObject;
import com.sinosoftgz.common.utils.DateUtils;
import com.sinosoftgz.common.utils.StringUtils;
import com.sinosoftgz.generator.domain.GenTable;
import com.sinosoftgz.generator.domain.GenTableColumn;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;

public class VelocityUtils {
    private static final String PROJECT_PATH_MAIN = "main/java";
    private static final String PROJECT_PATH_TEST = "test/java";
    private static final String MYBATIS_PATH = "main/resources/mapper";
    private static final String DEFAULT_PARENT_MENU_ID = "3";

    public static VelocityContext prepareContext(GenTable genTable) {
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", (Object)genTable.getTplCategory());
        velocityContext.put("tableName", (Object)genTable.getTableName());
        velocityContext.put("functionName", (Object)(StringUtils.isNotEmpty((String)functionName) ? functionName : "\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011"));
        velocityContext.put("ClassName", (Object)genTable.getClassName());
        velocityContext.put("className", (Object)StringUtils.uncapitalize((String)genTable.getClassName()));
        velocityContext.put("moduleName", (Object)genTable.getModuleName());
        velocityContext.put("BusinessName", (Object)StringUtils.capitalize((String)genTable.getBusinessName()));
        velocityContext.put("businessName", (Object)genTable.getBusinessName());
        velocityContext.put("basePackage", (Object)VelocityUtils.getPackagePrefix(packageName));
        velocityContext.put("packageName", (Object)packageName);
        String author = System.getProperty("user.name");
        velocityContext.put("author", (Object)(author == null ? genTable.getFunctionAuthor() : author));
        velocityContext.put("datetime", (Object)DateUtils.getTime());
        velocityContext.put("pkColumn", (Object)genTable.getPkColumn());
        if ("String".equals(genTable.getPkColumn().getJavaType())) {
            velocityContext.put("pkColumnIsString", (Object)true);
        } else {
            velocityContext.put("pkColumnIsString", (Object)false);
        }
        velocityContext.put("importList", VelocityUtils.getImportList(genTable));
        velocityContext.put("permissionPrefix", (Object)VelocityUtils.getPermissionPrefix(moduleName, businessName));
        velocityContext.put("columns", genTable.getColumns());
        velocityContext.put("table", (Object)genTable);
        VelocityUtils.setMenuVelocityContext(velocityContext, genTable);
        if ("tree".equals(tplCategory)) {
            VelocityUtils.setTreeVelocityContext(velocityContext, genTable);
        }
        if ("sub".equals(tplCategory)) {
            VelocityUtils.setSubVelocityContext(velocityContext, genTable);
        }
        return velocityContext;
    }

    public static void setMenuVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String parentMenuId = VelocityUtils.getParentMenuId(paramsObj);
        context.put("parentMenuId", (Object)parentMenuId);
    }

    public static void setTreeVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String treeCode = VelocityUtils.getTreecode(paramsObj);
        String treeParentCode = VelocityUtils.getTreeParentCode(paramsObj);
        String treeName = VelocityUtils.getTreeName(paramsObj);
        context.put("treeCode", (Object)treeCode);
        context.put("treeParentCode", (Object)treeParentCode);
        context.put("treeName", (Object)treeName);
        context.put("expandColumn", (Object)VelocityUtils.getExpandColumn(genTable));
        if (paramsObj.containsKey((Object)"treeParentCode")) {
            context.put("tree_parent_code", (Object)paramsObj.getString("treeParentCode"));
        }
        if (paramsObj.containsKey((Object)"treeName")) {
            context.put("tree_name", (Object)paramsObj.getString("treeName"));
        }
    }

    public static void setSubVelocityContext(VelocityContext context, GenTable genTable) {
        GenTable subTable = genTable.getSubTable();
        String subTableName = genTable.getSubTableName();
        String subTableFkName = genTable.getSubTableFkName();
        String subClassName = genTable.getSubTable().getClassName();
        String subTableFkClassName = StringUtils.convertToCamelCase((String)subTableFkName);
        context.put("subTable", (Object)subTable);
        context.put("subTableName", (Object)subTableName);
        context.put("subTableFkName", (Object)subTableFkName);
        context.put("subTableFkClassName", (Object)subTableFkClassName);
        context.put("subTableFkclassName", (Object)StringUtils.uncapitalize((String)subTableFkClassName));
        context.put("subClassName", (Object)subClassName);
        context.put("subclassName", (Object)StringUtils.uncapitalize((String)subClassName));
        context.put("subImportList", VelocityUtils.getImportList(genTable.getSubTable()));
    }

    public static List<String> getTemplateList(String tplCategory, String ormCategory, String rpcCategory) {
        LinkedList<String> templates = new LinkedList<String>();
        VelocityUtils.generatorRpc(rpcCategory, templates);
        templates.add("vm/common/java/vo.java.vm");
        templates.add("vm/common/java/dto.java.vm");
        templates.add("vm/common/java/mapstruct-poMapDto.java.vm");
        templates.add("vm/common/java/mapstruct-dtoMapVo.java.vm");
        templates.add("vm/common/java/biz.java.vm");
        templates.add("vm/common/java/consumerBiz.java.vm");
        VelocityUtils.generatorOrm(tplCategory, ormCategory, templates);
        templates.add("vm/common/sql/sql.vm");
        templates.add("vm/common/js/api.js.vm");
        if ("crud".equals(tplCategory)) {
            templates.add("vm/common/vue/index.vue.vm");
        } else if ("tree".equals(tplCategory)) {
            templates.add("vm/common/vue/index-tree.vue.vm");
        } else if ("sub".equals(tplCategory)) {
            templates.add("vm/common/vue/index.vue.vm");
        }
        return templates;
    }

    private static void generatorRpc(String rpcCategory, List<String> templates) {
        if ("motan".equals(rpcCategory)) {
            templates.add("vm/rpc/motan/java/motanApi.java.vm");
            templates.add("vm/rpc/motan/java/motanApiImpl.java.vm");
            templates.add("vm/rpc/motan/java/consumer/consumerBizImpl.java.vm");
        } else if ("dubbo".equals(rpcCategory)) {
            templates.add("vm/rpc/dubbo/java/dubboApi.java.vm");
            templates.add("vm/rpc/dubbo/java/dubboApiImpl.java.vm");
            templates.add("vm/rpc/dubbo/java/consumer/consumerBizImpl.java.vm");
        }
    }

    private static void generatorOrm(String tplCategory, String ormCategory, List<String> templates) {
        if ("mybatis".equals(ormCategory)) {
            templates.add("vm/orm/mybatis/java/bizImpl.java.vm");
            templates.add("vm/orm/mybatis/java/domain.java.vm");
            templates.add("vm/orm/mybatis/java/service.java.vm");
            templates.add("vm/orm/mybatis/java/serviceImpl.java.vm");
            templates.add("vm/orm/mybatis/java/mapper.java.vm");
            templates.add("vm/orm/mybatis/xml/mapper.xml.vm");
            templates.add("vm/orm/mybatis/java/controller.java.vm");
            if ("sub".equals(tplCategory)) {
                templates.add("vm/orm/mybatis/java/sub-domain.java.vm");
            }
        } else if (!"mybatis-plus".equals(ormCategory) && "jpa".equals(ormCategory)) {
            templates.add("vm/orm/jpa/java/bizImpl.java.vm");
            templates.add("vm/orm/jpa/java/domain.java.vm");
            templates.add("vm/orm/jpa/java/service.java.vm");
            templates.add("vm/orm/jpa/java/serviceImpl.java.vm");
            templates.add("vm/orm/jpa/java/specification.java.vm");
            templates.add("vm/orm/jpa/java/repos.java.vm");
            templates.add("vm/orm/jpa/java/testBiz.java.vm");
            templates.add("vm/orm/jpa/java/testService.java.vm");
            if ("sub".equals(tplCategory)) {
                templates.add("vm/orm/jpa/java/sub-domain.java.vm");
            }
        }
    }

    public static String getFileName(String template, GenTable genTable) {
        String fileName = "";
        String packageName = genTable.getPackageName();
        String moduleName = genTable.getModuleName();
        String className = genTable.getClassName();
        String businessName = genTable.getBusinessName();
        String javaPath = "main/java/" + StringUtils.replace((String)packageName, (String)".", (String)"/");
        String testPath = "test/java/" + StringUtils.replace((String)packageName, (String)".", (String)"/");
        String mybatisPath = "main/resources/mapper/" + moduleName;
        String vuePath = "vue";
        if (template.contains("domain.java.vm")) {
            fileName = StringUtils.format((String)"{}/domain/{}.java", (Object[])new Object[]{javaPath, className});
        }
        if (template.contains("sub-domain.java.vm") && StringUtils.equals((CharSequence)"sub", (CharSequence)genTable.getTplCategory())) {
            fileName = StringUtils.format((String)"{}/domain/{}.java", (Object[])new Object[]{javaPath, genTable.getSubTable().getClassName()});
        } else if (template.contains("mapper.java.vm")) {
            fileName = StringUtils.format((String)"{}/mapper/{}Mapper.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("service.java.vm")) {
            fileName = StringUtils.format((String)"{}/service/I{}Service.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("serviceImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/service/impl/{}ServiceImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("controller.java.vm")) {
            fileName = StringUtils.format((String)"{}/controller/{}Controller.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapper.xml.vm")) {
            fileName = StringUtils.format((String)"{}/{}Mapper.xml", (Object[])new Object[]{mybatisPath, className});
        } else if (template.contains("sql.vm")) {
            fileName = businessName + "Menu.sql";
        } else if (template.contains("api.js.vm")) {
            fileName = StringUtils.format((String)"{}/api/{}/{}.js", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("index.vue.vm")) {
            fileName = StringUtils.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("index-tree.vue.vm")) {
            fileName = StringUtils.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("dto.java.vm")) {
            fileName = StringUtils.format((String)"{}/dto/{}DTO.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("vo.java.vm")) {
            fileName = StringUtils.format((String)"{}/vo/{}VO.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapstruct-poMapDto.java.vm")) {
            fileName = StringUtils.format((String)"{}/mapping/{}Mapping.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapstruct-dtoMapVo.java.vm")) {
            fileName = StringUtils.format((String)"{}/mapping/{}DTOMapping.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("motanApi.java.vm")) {
            fileName = StringUtils.format((String)"{}/protocal/rpc/api/{}Api.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("motanApiImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/protocal/rpc/motan/impl/{}ApiImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("dubboApi.java.vm")) {
            fileName = StringUtils.format((String)"{}/protocal/rpc/api/{}Api.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("dubboApiImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/protocal/rpc/dubbo/impl/{}ApiImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("biz.java.vm")) {
            fileName = StringUtils.format((String)"{}/biz/{}Biz.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("bizImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/biz/impl/{}BizImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("repos.java.vm")) {
            fileName = StringUtils.format((String)"{}/repository/{}Repos.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("specification.java.vm")) {
            fileName = StringUtils.format((String)"{}/specification/{}Specification.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("testBiz.java.vm")) {
            fileName = StringUtils.format((String)"{}/biz/{}BizTest.java", (Object[])new Object[]{testPath, className});
        } else if (template.contains("testService.java.vm")) {
            fileName = StringUtils.format((String)"{}/service/I{}ServiceTest.java", (Object[])new Object[]{testPath, className});
        } else if (template.contains("consumerBiz.java.vm")) {
            fileName = StringUtils.format((String)"{}/consumer/biz/{}Biz.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("consumerBizImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/consumer/biz/impl/{}BizImpl.java", (Object[])new Object[]{javaPath, className});
        }
        return fileName;
    }

    public static String getPackagePrefix(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringUtils.substring((String)packageName, (int)0, (int)lastIndex);
        return basePackage;
    }

    public static HashSet<String> getImportList(GenTable genTable) {
        List<GenTableColumn> columns = genTable.getColumns();
        GenTable subGenTable = genTable.getSubTable();
        HashSet<String> importList = new HashSet<String>();
        if (StringUtils.isNotNull((Object)((Object)subGenTable))) {
            importList.add("java.util.List");
        }
        for (GenTableColumn column : columns) {
            if (!column.isSuperColumn() && "Date".equals(column.getJavaType())) {
                importList.add("java.util.Date");
                continue;
            }
            if (column.isSuperColumn() || !"BigDecimal".equals(column.getJavaType())) continue;
            importList.add("java.math.BigDecimal");
        }
        return importList;
    }

    public static String getPermissionPrefix(String moduleName, String businessName) {
        return StringUtils.format((String)"{}:{}", (Object[])new Object[]{moduleName, businessName});
    }

    public static String getParentMenuId(JSONObject paramsObj) {
        if (StringUtils.isNotEmpty((Map)paramsObj) && paramsObj.containsKey((Object)"parentMenuId")) {
            return paramsObj.getString("parentMenuId");
        }
        return DEFAULT_PARENT_MENU_ID;
    }

    public static String getTreecode(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeCode")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeCode"));
        }
        return "";
    }

    public static String getTreeParentCode(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeParentCode")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeParentCode"));
        }
        return "";
    }

    public static String getTreeName(JSONObject paramsObj) {
        if (paramsObj.containsKey((Object)"treeName")) {
            return StringUtils.toCamelCase((String)paramsObj.getString("treeName"));
        }
        return "";
    }

    public static int getExpandColumn(GenTable genTable) {
        String options = genTable.getOptions();
        JSONObject paramsObj = JSONObject.parseObject((String)options);
        String treeName = paramsObj.getString("treeName");
        int num = 0;
        for (GenTableColumn column : genTable.getColumns()) {
            if (!column.isList()) continue;
            ++num;
            String columnName = column.getColumnName();
            if (!columnName.equals(treeName)) continue;
            break;
        }
        return num;
    }
}

