/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.context;

import cn.hutool.core.util.StrUtil;
import com.yomahub.tlog.context.TLogContext;
import org.apache.commons.lang3.StringUtils;

public class SpanIdGenerator {
    private static InheritableThreadLocal<String> currentSpanIdTL = new InheritableThreadLocal();
    private static InheritableThreadLocal<Integer> spanIndex = new InheritableThreadLocal();
    private static String INITIAL_VALUE = "0";

    public static void putSpanId(String spanId) {
        if (StringUtils.isBlank((CharSequence)spanId)) {
            spanId = INITIAL_VALUE;
        }
        currentSpanIdTL.set(spanId);
        spanIndex.set(Integer.valueOf(INITIAL_VALUE));
    }

    public static String getSpanId() {
        return (String)currentSpanIdTL.get();
    }

    public static void removeSpanId() {
        currentSpanIdTL.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateNextSpanId() {
        String string = TLogContext.getTraceId();
        synchronized (string) {
            String currentSpanId = TLogContext.getSpanId();
            spanIndex.set((Integer)spanIndex.get() + 1);
            String nextSpanId = StrUtil.format((CharSequence)"{}.{}", (Object[])new Object[]{currentSpanId, spanIndex.get()});
            return nextSpanId;
        }
    }
}

