/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.feign.filter;

import cn.hutool.core.net.NetUtil;
import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TLogFeignFilter
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TLogFeignFilter.class);
    @Value(value="${spring.application.name}")
    private String appName;

    public void apply(RequestTemplate requestTemplate) {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String hostName = "NONE";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            requestTemplate.header("tlog_trace_id", new String[]{traceId});
            requestTemplate.header("tlog_spanid", new String[]{SpanIdGenerator.generateNextSpanId()});
            requestTemplate.header("pre_ivk_app", new String[]{this.appName});
            requestTemplate.header("pre_ivk_host", new String[]{hostName});
            requestTemplate.header("pre_ip", new String[]{NetUtil.getLocalhostStr()});
        } else {
            log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

