/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.web.common;

import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.core.rpc.TLogRPCHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogWebCommon
extends TLogRPCHandler {
    private static final Logger log = LoggerFactory.getLogger(TLogWebCommon.class);
    private static volatile TLogWebCommon tLogWebCommon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TLogWebCommon loadInstance() {
        if (tLogWebCommon != null) return tLogWebCommon;
        Class<TLogWebCommon> clazz = TLogWebCommon.class;
        synchronized (TLogWebCommon.class) {
            if (tLogWebCommon != null) return tLogWebCommon;
            tLogWebCommon = new TLogWebCommon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tLogWebCommon;
        }
    }

    public void preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String traceId = request.getHeader("tlog_trace_id");
        String spanId = request.getHeader("tlog_spanid");
        String preIvkApp = request.getHeader("pre_ivk_app");
        String preIvkHost = request.getHeader("pre_ivk_host");
        String preIp = request.getHeader("pre_ip");
        TLogLabelBean labelBean = new TLogLabelBean(preIvkApp, preIvkHost, preIp, traceId, spanId);
        this.processProviderSide(labelBean);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.cleanThreadLocal();
    }
}

