/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.global.common.request.page;

import com.sinosoftgz.global.common.utils.LangUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

@ApiModel(value="PageQueryRequest", description="\u5206\u9875\u8bf7\u6c42\u5bf9\u8c61")
public class PageQueryRequest<T>
implements Serializable {
    private static final Integer MAX_LIMIT = 10000;
    @ApiModelProperty(value="\u5f53\u524d\u8bb0\u5f55\u8d77\u59cb\u7d22\u5f15", required=true)
    @NotNull
    private Integer pageNum = 0;
    @ApiModelProperty(value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", required=true)
    @NotNull
    private Integer pageSize = 10;
    @ApiModelProperty(value="\u8bf7\u6c42\u5b9e\u4f53\u5bf9\u8c61")
    private T entity;
    @ApiModelProperty(value="\u6392\u5e8f\u5217")
    Map<String, String> orderByColumn = new LinkedHashMap<String, String>();
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    public Integer getPageSize() {
        if (this.pageSize > MAX_LIMIT) {
            return MAX_LIMIT;
        }
        return this.pageSize;
    }

    public PageQueryRequest() {
    }

    public PageQueryRequest(Integer pageNum, Integer pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public PageQueryRequest(Integer pageNum, Integer pageSize, T entity) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.entity = entity;
    }

    public static Pageable convertToPageable(PageQueryRequest pageQueryRequest) {
        Assert.notNull((Object)pageQueryRequest, (String)"Object must be have value!");
        Map<String, String> orderByColumn = pageQueryRequest.getOrderByColumn();
        PageRequest pageable = null;
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (!LangUtils.isEmpty(orderByColumn) && orders.size() > 0) {
            for (String key : orderByColumn.keySet()) {
                String value = orderByColumn.get(key);
                Sort.Order order = null;
                order = DESC.equals(value) ? new Sort.Order(Sort.Direction.DESC, key) : new Sort.Order(Sort.Direction.ASC, key);
                orders.add(order);
            }
        }
        if (!LangUtils.isEmpty(orders) && orders.size() > 0) {
            Sort sort = new Sort(orders);
            pageable = new PageRequest(pageQueryRequest.getPageNum().intValue(), pageQueryRequest.getPageSize().intValue(), sort);
        } else {
            pageable = new PageRequest(pageQueryRequest.getPageNum().intValue(), pageQueryRequest.getPageSize().intValue());
        }
        return pageable;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public T getEntity() {
        return this.entity;
    }

    public Map<String, String> getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public void setOrderByColumn(Map<String, String> orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageQueryRequest)) {
            return false;
        }
        PageQueryRequest other = (PageQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        T this$entity = this.getEntity();
        T other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        Map<String, String> this$orderByColumn = this.getOrderByColumn();
        Map<String, String> other$orderByColumn = other.getOrderByColumn();
        return !(this$orderByColumn == null ? other$orderByColumn != null : !((Object)this$orderByColumn).equals(other$orderByColumn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        T $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        Map<String, String> $orderByColumn = this.getOrderByColumn();
        result = result * 59 + ($orderByColumn == null ? 43 : ((Object)$orderByColumn).hashCode());
        return result;
    }

    public String toString() {
        return "PageQueryRequest(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", entity=" + this.getEntity() + ", orderByColumn=" + this.getOrderByColumn() + ")";
    }

    @ConstructorProperties(value={"pageNum", "pageSize", "entity", "orderByColumn"})
    public PageQueryRequest(Integer pageNum, Integer pageSize, T entity, Map<String, String> orderByColumn) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.entity = entity;
        this.orderByColumn = orderByColumn;
    }
}

