/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.global.common.response;

import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="BaseResponse", description="\u57fa\u7840\u8fd4\u56de\u5bf9\u8c61")
public class BaseResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u6210\u529f\u6807\u5fd7")
    private boolean success = true;
    @ApiModelProperty(value="\u6d88\u606f")
    private String message = CommonResponseCodeEnum.SUCCESS.getResultMsg();
    @ApiModelProperty(value="\u4ee3\u7801")
    private String code = CommonResponseCodeEnum.SUCCESS.getResultCode();
    @ApiModelProperty(value="\u6570\u636e\u5bf9\u8c61")
    private T result;
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private long timestamp = System.currentTimeMillis();

    public static <T> BaseResponse<T> ok() {
        return BaseResponse.ok(null);
    }

    public static <T> BaseResponse<T> ok(T result) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setResult(result);
        return r;
    }

    public static <T> BaseResponse<T> ok(String code, String message) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static <T> BaseResponse<T> ok(String code, String message, T result) {
        BaseResponse<T> r = BaseResponse.ok(code, message);
        r.setResult(result);
        return r;
    }

    public static <T> BaseResponse<T> bad(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.BAD_REQUEST.getResultCode(), message);
    }

    public static <T> BaseResponse<T> unauthorized(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.UNAUTHORIZED.getResultCode(), message);
    }

    public static <T> BaseResponse<T> forbidden(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.FORBIDDEN.getResultCode(), message);
    }

    public static <T> BaseResponse<T> notFind(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.NOT_FOUND.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(T result) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setCode(CommonResponseCodeEnum.SERVER_ERROR.getResultCode());
        r.setMessage(CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
        r.setResult(result);
        return r;
    }

    public static <T> BaseResponse<T> error() {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_ERROR.getResultCode(), CommonResponseCodeEnum.SERVER_ERROR.getResultMsg());
    }

    public static <T> BaseResponse<T> unavailable(String message) {
        return BaseResponse.error(CommonResponseCodeEnum.SERVER_UNAVAILABLE.getResultCode(), message);
    }

    public static <T> BaseResponse<T> error(String code, String message) {
        BaseResponse<T> r = new BaseResponse<T>();
        r.setSuccess(Boolean.FALSE);
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static <T> BaseResponse<T> error(String code, String message, T result) {
        BaseResponse<T> r = BaseResponse.error(code, message);
        r.setResult(result);
        return r;
    }

    public BaseResponse<T> code(String code) {
        this.code = code;
        return this;
    }

    public BaseResponse<T> message(String message) {
        this.message = message;
        return this;
    }

    public BaseResponse<T> result(T result) {
        this.result = result;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public T getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public String toString() {
        return "BaseResponse(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", result=" + this.getResult() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

