package com.sinosoftgz.global.common.constants;

/**
 * Created by Roney on 2019/3/21 11:45
 *
 * @author Roney
 */
public abstract class CommonConstants {

    /**
     * 返回的状态
     */
    public class ResponseStatus {
        /**
         * 成功
         */
        public static final String SUCCESS = "SUCCESS";
        /**
         * 错误
         */
        public static final String ERROR = "ERROR";
    }

    /**
     * 返回状态
     */
    public class ResponseString {
        /**
         * 状态
         */
        public static final String STATUS = "status";
        /**
         * 错误代码
         */
        public static final String ERROR_CODE = "error";
        public static final String MESSAGE = "message";
        /**
         * 数据
         */
        public static final String DATA = "data";
    }

    public class MessageString {
        /**
         * Object must be have value
         */
        public static final String ASSERT_NOT_NULL_OBJECT_MESSAGE = "Object must be have value!";

        /**
         * id must be have value
         */
        public static final String ASSERT_NOT_NULL_ID_MESSAGE = "id must be have value!";

        /**
         * ids must be have value
         */
        public static final String ASSERT_NOT_NULL_IDS_MESSAGE = "ids must be have value!";

        /**
         * propertyName must be have value
         */
        public static final String ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE = "%s must be have value!";
    }


    /**
     * 数字+字母大小写字符串
     */
    public static final String ALL_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    /**
     * 字母大小写字符串
     */
    public static final String LETTER_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    /**
     * 数字字符串
     */
    public static final String NUMBER_CHAR = "0123456789";

    /**
     * 字符串常量：英文问号?
     */
    public static final String QUESTION_MARK = "?";

    /**
     * 字符常量：与 {@code '&'}
     */
    public static final String AMP = "&";


    /**
     * 邮箱正则表达式
     */
    public static final String EMAIL_REGULAR = "^([a-z0-9A-Z]+([-|_|\\.&]|__)?)+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+){0,}\\.)+[a-zA-Z]{2,}$";

    /**
     * 手机号正则表达式
     */
    public static final String PHONE_REGULAR = "^([1][3,4,5,6,7,8,9][0-9]{9}|(950)[0-9]*)$";


}
