package com.sinosoftgz.global.common.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * api 基础查询对象
 * Created by Roney on 2019/3/22 16:49
 *
 * @author Roney
 */
@SuppressWarnings("ALL")
@Data
@AllArgsConstructor
@NoArgsConstructor
public abstract class AbstractBaseRequest<T> implements Serializable {

    /**
     * 标志某一个请求,可以按其跟踪一个接口的请求
     */
    @NotNull
    protected String requestId = String.valueOf(System.nanoTime());

    /**
     * 请求时间
     */
    @NotNull
    protected String requestDate = String.valueOf(System.nanoTime());

    /**
     * 一些接口可能需要定义较长的超时时间,通过该属性修改处理
     *
     * @ignore
     */
    protected Long timeOut;

    /**
     * 标记一个用户的信息,在从报文体中分开
     *
     * @ignore
     */
    protected String token;

    /**
     * the business data
     *
     * @see T
     */
    @Valid
    protected T data;

}
