package com.sinosoftgz.global.common.request;

import java.io.Serializable;

/**
 * @author: Roney
 * @date: 2021-11-09 17:15
 * @description: 基础请求对象
 */
public class BaseRequest<T> extends AbstractBaseRequest<T> implements Serializable {

    /**
     * 快速构建方法
     *
     * @return
     */
    public static <T> BaseRequest<T> simple(T t) {
        BaseRequest<T> r = new BaseRequest<>();
        r.setData(t);
        r.setRequestId(String.valueOf(System.nanoTime()));
        r.setTimeOut(60 * 1000L);
        r.setToken("simple");
        return r;
    }

    public BaseRequest<T> token(String token) {
        this.token = token;
        return this;
    }

    public BaseRequest<T> requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BaseRequest<T> timeOut(Long timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public BaseRequest<T> data(T data) {
        this.data = data;
        return this;
    }

}
