package com.sinosoftgz.global.common.request.page;

import com.sinosoftgz.global.common.request.AbstractBaseRequest;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: Roney
 * @date: 2021-11-09 16:28
 * @description: 分页基础基类
 */
@Data
@NoArgsConstructor
public abstract class AbstractPageRequest<T> extends AbstractBaseRequest<T> implements Serializable {
    /**
     * 默认开始页
     */
    protected static final Integer DEFAULT_PAGE_NUM = 0;

    /**
     * 默认分页大小
     */
    protected static final Integer DEFAULT_PAGE_SIZE = 10;

    /**
     * 最多查询1万条数据，防止用户修改参数load全库数据
     */
    private static final Integer MAX_LIMIT = 10000;


    /**
     * 当前记录起始索引
     */
    @NotNull
    private Integer pageNum = 0;

    /**
     * 每页显示记录数
     */
    @NotNull
    private Integer pageSize = 10;

    public AbstractPageRequest(Integer pageNum, Integer pageSize) {

        if (pageNum < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }

        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }

        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        if (pageSize > MAX_LIMIT) {
            return MAX_LIMIT;
        }
        return pageSize;
    }
}
