package com.sinosoftgz.global.common.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 公用信息返回
 * Created by Roney on 2019/3/22 16:49
 *
 * @author Roney
 */
@SuppressWarnings("ALL")
@Data
@AllArgsConstructor
@NoArgsConstructor
public abstract class AbstractBaseResponse implements Serializable {
    /**
     * 返回流水号
     * 为了方便调试，可以将请求参数流水号设置为该值
     */
    private String responseId = String.valueOf(System.nanoTime());

    /**
     * 时间戳
     */
    private long timestamp = System.currentTimeMillis();

    /**
     * 系统识别号
     */
    protected String system;
}
