package com.sinosoftgz.global.common.response.enums;


/**
 * Created by Roney on 2019/3/21 13:38
 *
 * @author Roney
 */
public enum CommonResponseCodeEnum implements BaseErrorInfoInterface {

    /**
     *错误代码汇总
     */
    /**
     * 0**** 成功
     */
    //查询相关接口，调用成功时返回
    SUCCESS("00000", "操作成功"),

    /**
     * 1**** 参数问题
     */
    PARAMS_VALIDATION_EMTITY("10000", "参数校验错误"),
    PARAMS_EMPTY("10001", "参数为空"),
    PARAMS_FORMAT_ERROR("10002", "参数格式不正确"),
    PARAMS_VALUE_ERROR("10003", "参数值不正确"),
    PARAMS_REPEAT("10004", "参数重复"),
    PARAMS_CONVERT_ERROR("10005", "入参转化错误"),

    /**
     * 2**** 权限问题
     */

    /**
     * 3**** 业务问题
     */

    /**
     * 4**** 参数问题
     * <p>
     * 40000 Bad Request  //客户端请求有语法错误，不能被服务器所理解
     * 40001 Unauthorized //请求未经授权（未登录）
     * 40003 Forbidden  //服务器收到请求，但是拒绝提供服务（权限不足）
     * 40004 Not Found  //请求资源不存在，eg：输入了错误的URL
     */

    BAD_REQUEST("40000", "系统出现异常，请联系系统管理员"),
    UNAUTHORIZED("40001", "请求未经授权"),
    FORBIDDEN("40003", "服务器收到请求，但是拒绝提供服务"),
    NOT_FOUND("40004", "请求资源不存在"),

    /**
     * 5**** 系统异常
     * <p>
     * Internal Server Error
     * Server Unavailable
     */
    INTERNAL_SERVER_ERROR("50000", "服务器发生不可预期的错误"),
    SERVER_ERROR("50001", "服务异常，请稍后重试"),
    UNKNOWN_ERROR("50002", "未知错误"),
    SERVER_UNAVAILABLE("50003", "服务器当前不能处理客户端的请求，一段时间后可能恢复正常"),
    RPC_CALL_ERROR("50004", "服务不可用，请稍后重试"),

    /**
     * 6****数据问题
     */
    DATA_NO_EMPTY_ERROR("60000", "%s数据不能为空"),
    ;
    /**
     * 错误码
     */
    private String resultCode;

    /**
     * 错误描述
     */
    private String resultMsg;

    CommonResponseCodeEnum() {

    }

    CommonResponseCodeEnum(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    @Override
    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public String getResultMsg() {
        return resultMsg;
    }

    public void setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
    }
}
