package com.sinosoftgz.global.common.response.page;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 结果页对象. 包含当前页数据及分页信息如总记录数.
 *
 * @author Roney
 */
@Data
@AllArgsConstructor
public class ResultPage<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 当前页结果集在总记录中的的位置,从0开始
     */

    private long pageNo;
    /**
     * 当前页的记录数
     */

    private long perPage;

    /**
     * 总页数
     */

    private long totalPage;

    /**
     * 总记录数
     */

    private long totalCount;
    /**
     * 当前页中存放的记录,类型一般为List NOSONAR
     */

    private List<T> data;


    public int getTotalPages() {
        return perPage == 0 ? 1 : (int) Math.ceil((double) totalCount / (double) perPage);
    }


    public ResultPage() {
    }

    public ResultPage(long pageNo, long perPage) {
        this.pageNo = pageNo;
        this.perPage = perPage;
    }


}
