/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.okhttp.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OkHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private final String JSON_STR = "application/json; charset=utf-8";
    private final String XML_STR = "application/xml";
    private final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    @Autowired
    OkHttpClient okHttpClient;

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public <T> T get(@NonNull String url, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.get(url, null, null, clasz);
    }

    public void get(@NonNull String url, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.get(url, null, null, callback);
    }

    public <T> T get(@NonNull String url, Map<String, String> queryParameter, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.get(url, null, queryParameter, clasz);
    }

    public void get(@NonNull String url, Map<String, String> queryParameter, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.get(url, null, queryParameter, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(@NonNull String url, Map<String, String> headerParameter, Map<String, String> queryParameter, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processGetParameter(url, headerParameter, queryParameter);
        try (Response resp = this.okHttpClient.newCall(request).execute();){
            T t = this.processResponse(resp, clasz);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void get(@NonNull String url, Map<String, String> headerParameter, Map<String, String> queryParameter, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processGetParameter(url, headerParameter, queryParameter);
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    private Request processGetParameter(String url, Map<String, String> headerParameter, Map<String, String> queryParameter) {
        Request.Builder builder = new Request.Builder();
        if (!this.isEmptyMap(headerParameter)) {
            builder.headers(Headers.of(headerParameter));
        }
        if (this.isEmptyMap(queryParameter)) {
            builder.url(url);
        } else {
            boolean hasQuery = false;
            try {
                hasQuery = new URL(url).getQuery().isEmpty();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("url is illegal");
            }
            StringBuilder sb = new StringBuilder(url);
            if (!hasQuery) {
                sb.append("?1=1");
            }
            queryParameter.forEach((k, v) -> sb.append("&").append((String)k).append("=").append((String)v));
            builder.url(sb.toString());
        }
        return builder.build();
    }

    public <T> T postJson(@NonNull String url, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.postJson(url, null, null, clasz);
    }

    public void postJson(@NonNull String url, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.postJson(url, null, null, callback);
    }

    public <T> T postJson(@NonNull String url, Map<String, String> headerParameter, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.postJson(url, headerParameter, null, clasz);
    }

    public void postJson(@NonNull String url, Map<String, String> headerParameter, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.postJson(url, headerParameter, null, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postJson(@NonNull String url, Map<String, String> headerParameter, Object bodyObj, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processPostJsonParameter(url, headerParameter, bodyObj);
        try (Response resp = this.okHttpClient.newCall(request).execute();){
            T t = this.processResponse(resp, clasz);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postJson(@NonNull String url, Map<String, String> headerParameter, Object bodyObj, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processPostJsonParameter(url, headerParameter, bodyObj);
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    private Request processPostJsonParameter(String url, Map<String, String> headerParameter, Object bodyObj) {
        Request.Builder builder = new Request.Builder().url(url);
        if (!Objects.isNull(bodyObj)) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSONObject.toJSONString((Object)bodyObj));
            builder.post(body);
        } else {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"{}");
            builder.post(body);
        }
        if (!this.isEmptyMap(headerParameter)) {
            builder.headers(Headers.of(headerParameter));
        }
        return builder.build();
    }

    public <T> T postForm(@NonNull String url, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.postForm(url, null, null, clasz);
    }

    public void postForm(@NonNull String url, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.postForm(url, null, null, callback);
    }

    public <T> T postForm(@NonNull String url, Map<String, String> headerParameter, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return this.postForm(url, headerParameter, null, clasz);
    }

    public void postForm(@NonNull String url, Map<String, String> headerParameter, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.postForm(url, headerParameter, null, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postForm(@NonNull String url, Map<String, String> headerParameter, Map<String, String> parameters, Class<T> clasz) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processPostFormParameter(url, headerParameter, parameters);
        try (Response resp = this.okHttpClient.newCall(request).execute();){
            T t = this.processResponse(resp, clasz);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postForm(@NonNull String url, Map<String, String> headerParameter, Map<String, String> parameters, Callback callback) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        Request request = this.processPostFormParameter(url, headerParameter, parameters);
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    private Request processPostFormParameter(String url, Map<String, String> headerParameter, Map<String, String> parameters) {
        Request.Builder builder = new Request.Builder().url(url);
        if (!Objects.isNull(parameters)) {
            FormBody.Builder formBuilder = new FormBody.Builder();
            parameters.forEach((k, v) -> formBuilder.add(k, v));
            builder.post((RequestBody)formBuilder.build());
        }
        if (!this.isEmptyMap(headerParameter)) {
            builder.headers(Headers.of(headerParameter));
        }
        return builder.build();
    }

    private <T> T processResponse(Response resp, Class<T> clasz) throws IOException {
        if (resp.isSuccessful()) {
            if (Objects.equals(Void.class, clasz)) {
                return null;
            }
            String respStr = resp.body().string();
            if (Objects.equals(String.class, clasz)) {
                return (T)respStr;
            }
            return (T)JSONObject.parseObject((String)respStr, clasz);
        }
        return null;
    }

    private boolean isEmptyMap(Map<? extends Object, ? extends Object> map) {
        return Objects.isNull(map) || map.isEmpty();
    }
}

