package com.sinosoftgz.starter.okhttp.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.validation.constraints.NotNull;

/**
 * Created by Roney on 2020/12/2 15:12.
 */
@ConfigurationProperties(prefix = "okhttp")
@Data
public class OkHttpProperties {
    /**
     * 是否设置okhttp参数，默认false
     */
    private Boolean enabled = false;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private int writeTimeout = 10000;

    @NotNull
    private Integer maxIdle = 5;
    @NotNull
    private Long keepAliveDuration = 5L;
}
