package com.sinosoftgz.starter.okhttp.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by Roney on 2020/12/2 15:11.
 */
@ConfigurationProperties(prefix = "proxy")
@Data
public class ProxyProperties {
    /**
     * 是否启用代理，默认false
     */
    private Boolean enabled = false;
    /**
     * 代理主机地址
     */
    private String host;
    /**
     * 代理端口
     */
    private Integer port;

    /**
     * 开启代理鉴权
     */
    private Boolean enabledAuthenticator = false;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;
}
