/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.okhttp.config;

import com.sinosoftgz.starter.okhttp.properties.OkHttpProperties;
import com.sinosoftgz.starter.okhttp.properties.ProxyProperties;
import com.sinosoftgz.starter.okhttp.utils.OkHttpUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={ProxyProperties.class, OkHttpProperties.class})
@Configuration
public class OkHttpConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OkHttpConfiguration.class);
    private ProxyProperties proxyProperties;
    private OkHttpProperties okHttpProperties;

    public OkHttpConfiguration(ProxyProperties proxyProperties, OkHttpProperties okHttpProperties) {
        this.proxyProperties = proxyProperties;
        this.okHttpProperties = okHttpProperties;
    }

    @Bean
    OkHttpClient okHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.customizeOkHttp(builder);
        builder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                long t1 = System.nanoTime();
                log.info(String.format("\u53d1\u9001\u8bf7\u6c42: [%s] on %s%n\u8bf7\u6c42\u5934:%s%n\u8bf7\u6c42\u53c2\u6570:%s%n", request.url(), chain.connection(), request.headers(), request.body()));
                Response response = chain.proceed(request);
                long t2 = System.nanoTime();
                ResponseBody responseBody = response.peekBody(0x100000L);
                log.info(String.format("\u63a5\u6536\u54cd\u5e94:[%s] %n\u8fd4\u56dejson:[%s]%n\u8bf7\u6c42\u8017\u65f6:%.1fms%n%s", response.request().url(), responseBody.string(), (double)(t2 - t1) / 1000000.0, response.headers()));
                return response;
            }
        });
        return builder.build();
    }

    private void customizeOkHttp(OkHttpClient.Builder builder) {
        if (this.okHttpProperties.getEnabled().booleanValue()) {
            builder.connectTimeout((long)this.okHttpProperties.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)this.okHttpProperties.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)this.okHttpProperties.getWriteTimeout(), TimeUnit.SECONDS);
            builder.connectionPool(this.pool());
        }
        if (this.proxyProperties.getEnabled().booleanValue()) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyProperties.getHost(), (int)this.proxyProperties.getPort())));
        }
        if (this.proxyProperties.getEnabledAuthenticator().booleanValue()) {
            builder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)OkHttpConfiguration.this.proxyProperties.getUsername(), (String)OkHttpConfiguration.this.proxyProperties.getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
        }
    }

    @Bean
    public ConnectionPool pool() {
        return new ConnectionPool(this.okHttpProperties.getMaxIdle().intValue(), this.okHttpProperties.getKeepAliveDuration().longValue(), TimeUnit.MINUTES);
    }

    @Bean
    @ConditionalOnMissingBean
    public OkHttpUtils okHttpUtils(OkHttpClient okHttpClient) {
        OkHttpUtils okHttpUtils = new OkHttpUtils();
        okHttpUtils.setOkHttpClient(okHttpClient);
        return okHttpUtils;
    }
}

