/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.resttemplate.config;

import com.sinosoftgz.starter.resttemplate.properties.ProxyProperties;
import com.sinosoftgz.starter.resttemplate.properties.RestTemplateProperties;
import com.sinosoftgz.starter.resttemplate.utils.RestTemplateUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={ProxyProperties.class, RestTemplateProperties.class})
@Configuration
public class RestTemplateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfiguration.class);
    private ProxyProperties proxyProperties;
    private RestTemplateProperties restTemplateProperties;

    public RestTemplateConfiguration(ProxyProperties proxyProperties, RestTemplateProperties restTemplateProperties) {
        this.proxyProperties = proxyProperties;
        this.restTemplateProperties = restTemplateProperties;
    }

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        this.customizeRestTemplate(factory);
        return factory;
    }

    private void customizeRestTemplate(SimpleClientHttpRequestFactory factory) {
        if (this.restTemplateProperties.getEnabled().booleanValue()) {
            factory.setConnectTimeout(this.restTemplateProperties.getConnectTimeout());
            factory.setReadTimeout(this.restTemplateProperties.getReadTimeout());
        }
        if (this.proxyProperties.getEnabled().booleanValue()) {
            factory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyProperties.getHost(), (int)this.proxyProperties.getPort())));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateUtils restTemplateUtils(RestTemplate restTemplate) {
        RestTemplateUtils restTemplateUtils = new RestTemplateUtils(restTemplate);
        return restTemplateUtils;
    }
}

