/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.resttemplate.utils;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateUtils.class);
    private RestTemplate restTemplate;

    public RestTemplateUtils(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType) {
        return this.restTemplate.getForEntity(url, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.get(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.get(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Class<T> responseType) {
        return this.restTemplate.postForEntity(url, (Object)HttpEntity.EMPTY, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType) {
        return this.restTemplate.postForEntity(url, requestBody, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.post(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.post(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Class<T> responseType, Object ... uriVariables) {
        return this.put(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Class<T> responseType, Object ... uriVariables) {
        return this.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }
}

