package com.sinosoftgz.starter.resttemplate.config;

import com.sinosoftgz.starter.resttemplate.properties.RestTemplateProperties;
import com.sinosoftgz.starter.resttemplate.properties.ProxyProperties;
import com.sinosoftgz.starter.resttemplate.utils.RestTemplateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;


import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;

/**
 * Created by Roney on 2019/8/17.
 *
 * @author Roney
 * @date 2019-08-17 18:50
 */
@EnableConfigurationProperties({ProxyProperties.class, RestTemplateProperties.class})
@Configuration
@Slf4j
public class RestTemplateConfiguration {

    private ProxyProperties proxyProperties;

    private RestTemplateProperties restTemplateProperties;

    public RestTemplateConfiguration(ProxyProperties proxyProperties, RestTemplateProperties restTemplateProperties) {
        this.proxyProperties = proxyProperties;
        this.restTemplateProperties = restTemplateProperties;
    }

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        customizeRestTemplate(factory);
        return factory;
    }

    /**
     * 自定义参数
     *
     * @param factory
     */
    private void customizeRestTemplate(SimpleClientHttpRequestFactory factory) {
        if (restTemplateProperties.getEnabled()) {
            factory.setConnectTimeout(restTemplateProperties.getConnectTimeout());
            factory.setReadTimeout(restTemplateProperties.getReadTimeout());
        }
        if (proxyProperties.getEnabled()) {
            factory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyProperties.getHost(), proxyProperties.getPort())));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateUtils restTemplateUtils(RestTemplate restTemplate) {
        RestTemplateUtils restTemplateUtils = new RestTemplateUtils(restTemplate);
        return restTemplateUtils;
    }
}
