/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderIntelligenceDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderIntelligence;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderIntelligenceMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderIntelligenceDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderIntelligenceService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderIntelligenceServiceImpl
extends ServiceImpl<PrdOrderIntelligenceMapper, PrdOrderIntelligence>
implements OrderIntelligenceService {
    @Resource
    PrdOrderIntelligenceMapper prdOrderIntelligenceMapper;
    @Resource
    OrderIntelligenceDTOMapper orderIntelligenceDTOMapper;

    @Override
    public OrderIntelligenceDTO insertIntelligence(OrderIntelligenceDTO dto) {
        PrdOrderIntelligence entity = (PrdOrderIntelligence)this.orderIntelligenceDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderIntelligenceMapper.insertPrdOrderIntelligence(entity);
        dto = (OrderIntelligenceDTO)this.orderIntelligenceDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderIntelligenceDTO updateIntelligence(OrderIntelligenceDTO dto) {
        PrdOrderIntelligence entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderIntelligence)this.orderIntelligenceDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderIntelligenceMapper.updatePrdOrderIntelligence(entity);
        dto = (OrderIntelligenceDTO)this.orderIntelligenceDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderIntelligenceDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderIntelligence> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderIntelligenceDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderIntelligence> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderIntelligenceMapper.deletePrdOrderIntelligenceByIds(ids);
    }

    public List<PrdOrderIntelligence> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderIntelligenceMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

