/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderItemCarDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderItemCar;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderItemCarMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderItemCarDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderItemCarService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderItemCarServiceImpl
extends ServiceImpl<PrdOrderItemCarMapper, PrdOrderItemCar>
implements OrderItemCarService {
    @Resource
    PrdOrderItemCarMapper prdOrderItemCarMapper;
    @Resource
    OrderItemCarDTOMapper orderItemCarDTOMapper;

    @Override
    public List<OrderItemCarDTO> insertItemCar(List<OrderItemCarDTO> dtoList) {
        ArrayList<OrderItemCarDTO> dtos = new ArrayList<OrderItemCarDTO>();
        List entityList = this.orderItemCarDTOMapper.targetToSource(dtoList);
        for (PrdOrderItemCar entity : entityList) {
            entity.setVersion(Integer.valueOf("1"));
            entity.setDeleteFlag(Boolean.valueOf(false));
            this.prdOrderItemCarMapper.insertPrdOrderItemCar(entity);
            OrderItemCarDTO dto = (OrderItemCarDTO)this.orderItemCarDTOMapper.sourceToTarget(entity);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<OrderItemCarDTO> updateItemCar(List<OrderItemCarDTO> dtoList) {
        ArrayList<OrderItemCarDTO> dtos = new ArrayList<OrderItemCarDTO>();
        List entityList = this.orderItemCarDTOMapper.targetToSource(dtoList);
        Iterator iterator = entityList.iterator();
        while (iterator.hasNext()) {
            PrdOrderItemCar entity;
            entity.setVersion(Integer.valueOf((entity = (PrdOrderItemCar)iterator.next()).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
            this.prdOrderItemCarMapper.updatePrdOrderItemCar(entity);
            OrderItemCarDTO dto = (OrderItemCarDTO)this.orderItemCarDTOMapper.sourceToTarget(entity);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<OrderItemCarDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderItemCar> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderItemCarDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderItemCar> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderItemCarMapper.deletePrdOrderItemCarByIds(ids);
    }

    public List<PrdOrderItemCar> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderItemCarMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

