/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderMainDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderMain;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderMainMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderMainDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderMainService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderMainServiceImpl
extends ServiceImpl<PrdOrderMainMapper, PrdOrderMain>
implements OrderMainService {
    @Resource
    PrdOrderMainMapper prdOrderMainMapper;
    @Resource
    OrderMainDTOMapper orderMainDTOMapper;

    @Override
    public OrderMainDTO insertOrderMain(OrderMainDTO dto) {
        PrdOrderMain entity = (PrdOrderMain)this.orderMainDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderMainMapper.insertPrdOrderMain(entity);
        dto = (OrderMainDTO)this.orderMainDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderMainDTO updateOrderMain(OrderMainDTO dto) {
        PrdOrderMain entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderMain)this.orderMainDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderMainMapper.updatePrdOrderMain(entity);
        dto = (OrderMainDTO)this.orderMainDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderMainDTO findDtoByOrderNoOrOrderMainId(String orderNo, String orderMainId) {
        PrdOrderMain entity = this.findEntityByOrderNoOrOrderMainId(orderNo, orderMainId);
        OrderMainDTO dto = (OrderMainDTO)this.orderMainDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public void deleteByOrderNoOrOrderMainId(String orderNo, String orderMainId) {
        PrdOrderMain entity = this.findEntityByOrderNoOrOrderMainId(orderNo, orderMainId);
        String id = entity.getId();
        this.prdOrderMainMapper.deletePrdOrderMainById(id);
    }

    public PrdOrderMain findEntityByOrderNoOrOrderMainId(String orderNo, String orderMainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"id", (Object)orderMainId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        PrdOrderMain entity = (PrdOrderMain)this.prdOrderMainMapper.selectOne((Wrapper)queryWrapper);
        return entity;
    }
}

