/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderMerchandiserDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderMerchandiser;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderMerchandiserMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderMerchandiserDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderMerchandiserService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderMerchandiserServiceImpl
extends ServiceImpl<PrdOrderMerchandiserMapper, PrdOrderMerchandiser>
implements OrderMerchandiserService {
    @Resource
    PrdOrderMerchandiserMapper prdOrderMerchandiserMapper;
    @Resource
    OrderMerchandiserDTOMapper orderMerchandiserDTOMapper;

    @Override
    public OrderMerchandiserDTO insertMerchandiser(OrderMerchandiserDTO dto) {
        PrdOrderMerchandiser entity = (PrdOrderMerchandiser)this.orderMerchandiserDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderMerchandiserMapper.insertPrdOrderMerchandiser(entity);
        dto = (OrderMerchandiserDTO)this.orderMerchandiserDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderMerchandiserDTO updateMerchandiser(OrderMerchandiserDTO dto) {
        PrdOrderMerchandiser entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderMerchandiser)this.orderMerchandiserDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderMerchandiserMapper.updatePrdOrderMerchandiser(entity);
        dto = (OrderMerchandiserDTO)this.orderMerchandiserDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderMerchandiserDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderMerchandiser> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderMerchandiserDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderMerchandiser> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderMerchandiserMapper.deletePrdOrderMerchandiserByIds(ids);
    }

    public List<PrdOrderMerchandiser> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderMerchandiserMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

