/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderSubDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderSub;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderSubMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderSubDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderSubService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderSubServiceImpl
extends ServiceImpl<PrdOrderSubMapper, PrdOrderSub>
implements OrderSubService {
    @Resource
    PrdOrderSubMapper prdOrderSubMapper;
    @Resource
    OrderSubDTOMapper orderSubDTOMapper;

    @Override
    public OrderSubDTO insertOrderSub(OrderSubDTO dto) {
        PrdOrderSub entity = (PrdOrderSub)this.orderSubDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderSubMapper.insertPrdOrderSub(entity);
        dto = (OrderSubDTO)this.orderSubDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderSubDTO updateOrderSub(OrderSubDTO dto) {
        PrdOrderSub entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderSub)this.orderSubDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderSubMapper.updatePrdOrderSub(entity);
        dto = (OrderSubDTO)this.orderSubDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderSubDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderSub> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderSubDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderSub> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderSubMapper.deletePrdOrderSubByIds(ids);
    }

    public List<PrdOrderSub> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderSubMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

