package com.sinosoftgz.starter.mail.core.aop;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.mail.core.biz.MailLogBiz;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import com.sinosoftgz.starter.mail.log.storage.core.properties.MailLogStorageProperties;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;


/**
 * @author: Roney
 * @date: 2022-05-16 18:11
 * @description: 发送邮件日志切面
 */
@Configuration
@Aspect
@Slf4j
@ConditionalOnProperty(prefix = MailLogStorageProperties.MAIL_LOG_STORAGE_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class MailLogStorageAspect {

    @Resource
    MailLogBiz mailLogBiz;

    private final String ADD_POINT_CUT
            = " (execution(* com.sinosoftgz.starter.mail.core.handler..*.*(..))&& args(javaMailClientReq))";

    @Before("saveSendMailLog(javaMailClientReq)")
    public void sendSmsLogCall(JavaMailClientReq javaMailClientReq) {
        log.debug("send sms log ! javaMailClientReq:{}", JSON.toJSONString(javaMailClientReq));
        try {
            mailLogBiz.saveSendMailLog(javaMailClientReq);
        } catch (Exception e) {
            log.error("保存日志记录异常", e);
        }
    }

    @Pointcut(ADD_POINT_CUT)
    public void saveSendMailLog(JavaMailClientReq javaMailClientReq) {
    }
}
