package com.sinosoftgz.starter.mail.core.api;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.mail.core.request.MailSendReq;

import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-09 10:57
 * @description: 邮件接口
 * 各个业务方实现接口，默认是http协议，后续可以增加RPC等协议，由各个业务系统技术栈决定
 */
public interface MailSendApi {

    /**
     * 简单的纯文本邮件发送
     *
     * @param recipientTo 收件人
     * @param subject     主题
     * @param content     内容
     * @return 是否发送成功
     */
    public boolean sendSimpleMail(String recipientTo, String subject, String content);

    /**
     * 简单的HTML邮件发送
     *
     * @param recipientTo 收件人
     * @param subject     主题
     * @param content     内容
     * @return 是否发送成功
     */
    public boolean sendHtmlMail(String recipientTo, String subject, String content);


    /**
     * 发送邮件
     * 具体内容和信息由调用方拼装
     * 1.静态资源的邮件
     * 2.带附件的邮件
     *
     * @param mailSendReq 邮件请求对象
     * @return 是否发送成功
     */
    public boolean sendMail(BaseRequest<MailSendReq> mailSendReq);

    /**
     * 批量发送邮件
     * 具体内容和信息由调用方拼装
     *
     * @param mailSendReqs
     * @return 是否发送成功
     */
    public boolean batchSendMail(BaseRequest<List<MailSendReq>> mailSendReqs);
}
