package com.sinosoftgz.starter.mail.core.api.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.mail.core.biz.MailSendBiz;
import com.sinosoftgz.starter.mail.core.constant.MailConstants;
import com.sinosoftgz.starter.mail.core.request.MailSendReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 发送邮件 http 协议接口实现
 *
 * @author: Roney
 * @date: 2022-05-09 11:12
 * @description: 发送邮件 http 协议接口实现
 */
@RestController
@RequestMapping(MailConstants.APP_BASE_CONTEXT + "/send")
@Slf4j
public class MailSendApiRestController {

    @Resource
    MailSendBiz mailSendBiz;


    /**
     * 简单的纯文本邮件发送
     *
     * @param recipientTo 收件人
     * @param subject     主题
     * @param content     内容
     * @return 是否发送成功
     */

    @PostMapping("/simple")
    public BaseResponse sendSimpleMail(@RequestParam(name = "recipientTo", required = true) String recipientTo, String subject, String content) {
        return BaseResponse.ok(mailSendBiz.sendSimpleMail(recipientTo, subject, content));
    }

    /**
     * 简单的HTML邮件发送
     *
     * @param recipientTo 收件人
     * @param subject     主题
     * @param content     内容
     * @return 是否发送成功
     */
    @PostMapping("/html")
    public BaseResponse sendHtmlMail(@RequestParam(name = "recipientTo", required = true) String recipientTo, String subject, String content) {
        return BaseResponse.ok(mailSendBiz.sendHtmlMail(recipientTo, subject, content));
    }


    /**
     * 发送邮件
     * 具体内容和信息由调用方拼装
     * 1.静态资源的邮件
     * 2.带附件的邮件
     *
     * @param mailSendReq 邮件请求对象
     * @return 是否发送成功
     */
    @PostMapping("")
    public BaseResponse sendMail(BaseRequest<MailSendReq> mailSendReq) {
        return BaseResponse.ok(mailSendBiz.sendMail(mailSendReq));
    }

    /**
     * 批量发送邮件
     * 具体内容和信息由调用方拼装
     *
     * @param mailSendReqs
     * @return 是否发送成功
     */
    @PostMapping("/batch")
    public BaseResponse batchSendMail(BaseRequest<List<MailSendReq>> mailSendReqs) {
        return BaseResponse.ok(mailSendBiz.batchSendMail(mailSendReqs));
    }
}
