package com.sinosoftgz.starter.mail.core.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.mail.core.biz.MailLogBiz;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import com.sinosoftgz.starter.mail.log.storage.core.biz.MailLogStorageBiz;
import com.sinosoftgz.starter.mail.log.storage.core.request.MailFileDataReq;
import com.sinosoftgz.starter.mail.log.storage.core.request.MailLogStorageReq;
import com.sinosoftgz.starter.utils.date.DateUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-19 18:39
 * @description: 日志记录业务逻辑实现
 */
@Component
public class MailLogBizImpl implements MailLogBiz {
    @Resource
    MailLogStorageBiz mailLogStorageBiz;

    @Override
    public void saveSendMailLog(JavaMailClientReq javaMailClientReq) {
        checkJavaMailClient(javaMailClientReq);
        MailLogStorageReq mailLogStorageReq = BeanUtil.copyProperties(javaMailClientReq, MailLogStorageReq.class);
        mailLogStorageReq.setSendTime(DateUtils.now());
        if (!CollectionUtils.isEmpty(javaMailClientReq.getAttachments())) {
            List<MailFileDataReq> attachments = BeanUtil.copyToList(javaMailClientReq.getAttachments(), MailFileDataReq.class);
            mailLogStorageReq.setAttachments(attachments);
        }
        if (!CollectionUtils.isEmpty(javaMailClientReq.getImages())) {
            List<MailFileDataReq> images = BeanUtil.copyToList(javaMailClientReq.getImages(), MailFileDataReq.class);
            mailLogStorageReq.setImages(images);
        }
        mailLogStorageBiz.recordSendMailLog(BaseRequest.simple(mailLogStorageReq));
    }

    /**
     * 校验参数信息
     *
     * @param javaMailClientReq
     */
    public void checkJavaMailClient(JavaMailClientReq javaMailClientReq) {
        Assert.notNull(javaMailClientReq, "邮件发送统一请求对象不能为空");
        Assert.notEmpty(javaMailClientReq.getRecipientTos(), "收件人列表不能为空");
    }
}
