package com.sinosoftgz.starter.mail.core.config;

import com.sinosoftgz.starter.mail.core.api.impl.MailSendApiRestController;
import com.sinosoftgz.starter.mail.core.properties.MailPlatformProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Created by Roney on 2021/1/15 17:06.
 */
@Configuration
@Import({
        MailSendApiRestController.class
})
@ComponentScan(basePackages = {"com.sinosoftgz.starter.mail.core.**", "com.sinosoftgz.starter.spring.utils.**"})
@EnableConfigurationProperties(MailPlatformProperties.class)
public class CustomerMailConfiguration {

    MailPlatformProperties mailPlatformProperties;

    public CustomerMailConfiguration(final MailPlatformProperties mailPlatformProperties) {
        this.mailPlatformProperties = mailPlatformProperties;
    }
}
